﻿//////////////////////////////////////////////
// Function.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class UserType ;
}

/// Includes ---------------------------------

// nkScripts
#include "../../Dll/DllDefines.h"

#include "FunctionDefines.h"
#include "FunctionParameter.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT Function
	{
		public :

			// Default empty func
			OutputValue defaultFunction (const DataStack& stack) ;

		public :

			// Constructor, destructor
			Function (nkMemory::StringView name) noexcept ;
			virtual ~Function () ;

			// Getters
			nkMemory::StringView getName () const ;

			// Parameter management
			void addParameter (FUNCTION_PARAMETER_TYPE type, nkMemory::StringView userTypeName = "") ;

			// Callback management
			void setFunction (FunctionCallback function) ;

			// Reset to defaults
			void reset () ;

		protected :

			// Attributes
			nkMemory::String _name ;

			// Parameters to look for
			nkMemory::BufferCast<FunctionParameter> _parameters ;

			// Callback
			FunctionCallback _function ;
	} ;
}